% hamtrajectory plots trajectories in file outputtrajectories.dat created 
% by program ham.

rEarth = 6371.2e3;       % Radius of the earth [m]

inputham;

fid=fopen('outputtrajectories.dat','r');
inhalt=char(fread(fid)');
fclose(fid);

trstart=strfind(inhalt,'% trajectory');

% Add a false start at the end so that the for loop below works for the
% last trajectory too
trstart=[trstart length(inhalt)+1];


farben='krbgc';

figure(1)
klot([0 0 0],[0 0 1]*rEarth,'kb')
hold on
for ii=1:length(trstart)-1
  aa=strfind(inhalt(trstart(ii):trstart(ii)+50),char(10));
  trmat = str2num(inhalt(trstart(ii)+aa-1:trstart(ii+1)-1));

  % The positions are in the first three columns
  if ~isempty(trmat)
    r=trmat(:,1:3);
    plot3(r(:,1),r(:,2),r(:,3),farben(mod(ii-1,5)+1), ...
          r(1,1),r(1,2),r(1,3),[farben(mod(ii-1,5)+1) 'x'], ...
          r(end,1),r(end,2),r(end,3),[farben(mod(ii-1,5)+1) '*'])
  end
end
hold off
axis equal
xlabel('X');
ylabel('Y');
zlabel('Z');


figure(2)
clf
for ii=1:length(trstart)-1
  aa=strfind(inhalt(trstart(ii):trstart(ii)+50),char(10));
  trmat = str2num(inhalt(trstart(ii)+aa-1:trstart(ii+1)-1));
  
  if ~isempty(trmat)
    vv=trmat(:,5);
    mu=trmat(:,6);
    pangle=trmat(:,7);
    t=[0:length(vv)-1]*dt;

    subplot(3,1,1)
    plot(t,vv,farben(mod(ii-1,5)+1))
    hold on

    subplot(3,1,2)
    plot(t,mu,farben(mod(ii-1,5)+1))
    hold on

    subplot(3,1,3)
    plot(t,pangle,farben(mod(ii-1,5)+1))
    hold on
  end
end


subplot(3,1,1)
ylabel('|v| [m/s]','fontname','times','fontsize',18)
subplot(3,1,2)
ylabel('\mu  [Am^{2}]','fontname','times','fontsize',18)
subplot(3,1,3)
xlabel('time  [s]','fontname','times','fontsize',18)
ylabel('\alpha','fontname','times','fontsize',18)
